/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2complements.compat.ars.ArsRecipeCompat;
import dev.xkmc.l2complements.compat.forbidden.FaARecipe;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentRecipeBuilder
implements RecipeBuilder {
    public final Enchantment enchantment;
    public final int level;
    public final List<String> rows = Lists.newArrayList();
    public final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public EnchantmentRecipeBuilder(Enchantment p_126114_, int p_126115_) {
        this.enchantment = p_126114_;
        this.level = p_126115_;
    }

    public EnchantmentRecipeBuilder define(Character p_206417_, TagKey<Item> p_206418_) {
        return this.define(p_206417_, Ingredient.m_204132_(p_206418_));
    }

    public EnchantmentRecipeBuilder define(Character p_126128_, ItemLike p_126129_) {
        return this.define(p_126128_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126129_}));
    }

    public EnchantmentRecipeBuilder define(Character p_126125_, Ingredient p_126126_) {
        if (this.key.containsKey(p_126125_)) {
            throw new IllegalArgumentException("Symbol '" + p_126125_ + "' is already defined!");
        }
        if (p_126125_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_126125_, p_126126_);
        return this;
    }

    public EnchantmentRecipeBuilder pattern(String p_126131_) {
        if (!this.rows.isEmpty() && p_126131_.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(p_126131_);
        return this;
    }

    public EnchantmentRecipeBuilder unlockedBy(String p_126133_, CriterionTriggerInstance p_126134_) {
        this.advancement.m_138386_(p_126133_, p_126134_);
        return this;
    }

    public EnchantmentRecipeBuilder group(@Nullable String p_126146_) {
        this.group = p_126146_;
        return this;
    }

    public Item m_142372_() {
        return Items.f_42690_;
    }

    public void m_176498_(Consumer<FinishedRecipe> p_176499_) {
        this.m_126140_(p_176499_, new ResourceLocation("l2complements", ForgeRegistries.ENCHANTMENTS.getKey((Object)this.enchantment).m_135815_()));
    }

    public void m_126140_(Consumer<FinishedRecipe> pvd, ResourceLocation loc) {
        pvd = ArsRecipeCompat.saveCompat(this, pvd, loc);
        FaARecipe.saveCompat(this, loc);
        this.ensureValid(loc);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)loc)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)loc)).m_138360_(RequirementsStrategy.f_15979_);
        pvd.accept(new Result(loc, this.enchantment, this.level, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, new ResourceLocation(loc.m_135827_(), "recipes/enchantments/" + loc.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Enchantment ench;
        private final int lvl;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation p_176754_, Enchantment p_176755_, int p_176756_, String p_176757_, List<String> p_176758_, Map<Character, Ingredient> p_176759_, Advancement.Builder p_176760_, ResourceLocation p_176761_) {
            this.id = p_176754_;
            this.ench = p_176755_;
            this.lvl = p_176756_;
            this.group = p_176757_;
            this.pattern = p_176758_;
            this.key = p_176759_;
            this.advancement = p_176760_;
            this.advancementId = p_176761_;
        }

        public void m_7917_(JsonObject p_126167_) {
            if (!this.group.isEmpty()) {
                p_126167_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            p_126167_.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            p_126167_.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)Items.f_42690_).toString());
            JsonObject jsonObject2 = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject entry = new JsonObject();
            entry.addProperty("id", ForgeRegistries.ENCHANTMENTS.getKey((Object)this.ench).toString());
            entry.addProperty("lvl", (Number)this.lvl);
            list.add((JsonElement)entry);
            jsonObject2.add("StoredEnchantments", (JsonElement)list);
            jsonObject.add("nbt", (JsonElement)jsonObject2);
            p_126167_.add("result", (JsonElement)jsonObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

